function DTeX( D, r, c, info, file )
%DTEX Summary of this function goes here
%   Detailed explanation goes here

fid = fopen( file,'a');

if nargin < 4
    info = '';
end

s = size( D );
if nargin < 3 
    c = 1:s( 1 );
end

fprintf( fid, '\\begin{frame}\n' );
fprintf( fid, '   \\frametitle{Example}\n' );
fprintf( fid, '%s\n', info );
fprintf( fid, '   \\scriptsize\n' );

fprintf( fid, '   \\begin{tabular}{r|' );
for i = 1:s( 1 ) 
    fprintf( fid, 'r' );
end
fprintf( fid, '}\n' );

fprintf( fid, '      ' );
c = sort( unique( c ) );
for i = 1:s( 1 )
    if ( i == r( 1 ) )||( i == r( 2 ) ) 
        fprintf( fid, '&\\textcolor{red}{%d}', c( i ) );
    else
        fprintf( fid, '&%d', c( i ) );
    end
end
fprintf( fid, '\\\\\\hline\n' );

for i = 1:s( 1 )
    if ( i == r( 1 ) )||( i == r( 2 ) )
        fprintf( fid, '      \\textcolor{red}{%d}', c( i ) );
        for j = 1:s( 2 )
            if ( ( j == r( 1 ) )||( j == r( 2 ) ) ) && ( j ~= i )
                fprintf( fid, '&\\textcolor{blue}{%2.2f}', D( i, j ) );
            else
                fprintf( fid, '&\\textcolor{red}{%2.2f}', D( i, j ) );
            end
        end
    else
        fprintf( fid,  '      %d', c( i ) );
        for j = 1:s( 2 )
            if ( j == r( 1 ) )||( j == r( 2 ) )
                fprintf( fid, '&\\textcolor{red}{%2.2f}', D( i, j ) );
            else
                if i == j
                    fprintf( fid, '&\\textcolor{gray}{%2.2f}', D( i, j ) );
                else
                    fprintf( fid, '&%2.2f', D( i, j ) );
                end
            end
        end
    end
    fprintf( fid, '\\\\\n' );
end




fprintf( fid, '   \\end{tabular}\n' );
fprintf( fid, '   \\normalsize\n' );
fprintf( fid, '\\end{frame}\n' );



end

